/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import jade.core.AID;
import jade.util.leap.HashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.misc.BASE64Encoder;

public class CodeLocator {
    private static final String JAR_UID_ATTR = "jar-UID";
    private static final String HASH_ALGORITHM = "MD5";
    private static final int SIZE_CREATE_JAR_BUFFER = 4096;
    private static final int SIZE_HASH_JAR_BUFFER = 4096;
    private static BASE64Encoder b64Encoder = new BASE64Encoder();
    private final String TMP_JAR;
    private HashMap _agentsUsingJar = new HashMap();
    private HashMap _jarHash = new HashMap();
    private String _jarFolder;
    private Random _random;

    public CodeLocator(String agentsPath) {
        this._jarFolder = agentsPath;
        this.TMP_JAR = this._jarFolder + File.separator + "tmp.jar";
        this._random = new Random();
    }

    public synchronized String getAgentCodeLocation(AID name) {
        String mobileAgentUID = (String)this._agentsUsingJar.get(name);
        if (mobileAgentUID != null) {
            Row r = (Row)this._jarHash.get(mobileAgentUID);
            return r != null ? r.getLocation() : null;
        }
        return null;
    }

    private synchronized String getCodeByHash(String mobileAgentUID) {
        Row r = (Row)this._jarHash.get(mobileAgentUID);
        return r != null ? r.getLocation() : null;
    }

    public synchronized String registerAgent(AID name, byte[] code) throws Exception {
        return this.registerAgent(name, new ByteArrayInputStream(code));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String registerAgent(AID name, InputStream codestream) throws Exception {
        int bytes;
        File f = null;
        while ((f = new File(this._jarFolder + File.separator + this.randomString(8) + ".jar")).exists()) {
        }
        FileOutputStream fos = new FileOutputStream(f);
        byte[] buffy = new byte[512];
        while ((bytes = codestream.read(buffy)) != -1) {
            void var6_6;
            fos.write(buffy, 0, (int)var6_6);
        }
        codestream.close();
        fos.close();
        return this.registerAgent(name, f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public synchronized String registerAgent(AID name, File f, boolean userCreatedJar) throws Exception {
        String string;
        JarFile jf = new JarFile(f);
        Manifest man = null;
        Attributes att = null;
        String jarUID = null;
        man = jf.getManifest();
        if (man == null) break block9;
        att = man.getMainAttributes();
        jarUID = att.getValue(JAR_UID_ATTR);
        if (jarUID == null) break block10;
        jf.close();
        String string2 = this.registerJar(name, f.getPath(), jarUID, userCreatedJar);
        Object var10_10 = null;
        try {
            jf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        {
            block10: {
                block9: {
                    return string2;
                }
                man = new Manifest();
                att = man.getMainAttributes();
            }
            jarUID = this.calculateJarUID(jf);
            att.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            att.putValue(JAR_UID_ATTR, jarUID);
            this.copyJar(jf, this.TMP_JAR, man);
            jf.close();
            if (!f.delete()) {
                System.out.println("####################### DELETE of " + f.getPath() + "didn't work properly");
            }
            if (!new File(this.TMP_JAR).renameTo(f)) {
                System.out.println("####################### RENAME of " + f.getPath() + "didn't work properly");
            }
            string = this.registerJar(name, f.getPath(), jarUID, userCreatedJar);
        }
        Object var10_11 = null;
        try {
            jf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return string;
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                jf.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    private String registerJar(AID name, String path, String jarUID, boolean userCreatedJar) {
        Row r = (Row)this._jarHash.get(jarUID);
        if (r == null) {
            this._jarHash.put(jarUID, new Row(path, userCreatedJar));
            this._agentsUsingJar.put(name, jarUID);
            return path;
        }
        this._agentsUsingJar.put(name, jarUID);
        r.incRef();
        if (!userCreatedJar) {
            this.deleteFile(path);
        }
        return r.getLocation();
    }

    private void deleteFile(String path) {
        File f = new File(path);
        f.delete();
    }

    private void copyJar(JarFile jf, String path, Manifest man) throws IOException {
        Enumeration<JarEntry> entries = jf.entries();
        FileOutputStream fos = new FileOutputStream(path);
        JarOutputStream jos = new JarOutputStream((OutputStream)fos, man);
        int readed = 0;
        byte[] buffer = new byte[4096];
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (ze.getName().startsWith("META-INF")) continue;
            InputStream is = jf.getInputStream(ze);
            jos.putNextEntry(ze);
            while ((readed = is.read(buffer)) >= 0) {
                jos.write(buffer, 0, readed);
            }
            is.close();
            jos.closeEntry();
        }
        jos.flush();
        jos.close();
        fos.close();
    }

    /*
     * Unable to fully structure code
     */
    private String calculateJarUID(JarFile jf) throws IOException, NoSuchAlgorithmException {
        md = MessageDigest.getInstance("MD5");
        entries = jf.entries();
        readed = 0;
        buffer = new byte[4096];
        finalDigest = new byte[16];
        if (entries.hasMoreElements()) ** GOTO lbl17
        throw new IOException();
lbl-1000:
        // 1 sources

        {
            ze = entries.nextElement();
            if (ze.isDirectory() || ze.getName().startsWith("META-INF")) continue;
            md.reset();
            is = jf.getInputStream(ze);
            while ((readed = is.read(buffer)) >= 0) {
                md.update(buffer, 0, readed);
            }
            is.close();
            finalDigest = this.xor(finalDigest, md.digest());
lbl17:
            // 3 sources

            ** while (entries.hasMoreElements())
        }
lbl18:
        // 1 sources

        return CodeLocator.b64Encoder.encode(finalDigest);
    }

    private byte[] xor(byte[] first, byte[] second) {
        byte[] result = new byte[first.length];
        int i = 0;
        while (i < first.length) {
            result[i] = (byte)(first[i] ^ second[i]);
            ++i;
        }
        return result;
    }

    synchronized void changeAgentName(AID oldName, AID newName) {
        String jarUID = (String)this._agentsUsingJar.get(oldName);
        if (jarUID != null) {
            this._agentsUsingJar.put(newName, jarUID);
        }
    }

    public synchronized void removeAgentRef(AID name) {
        String jarUID = (String)this._agentsUsingJar.get(name);
        if (jarUID != null) {
            this._agentsUsingJar.remove(name);
            Row r = (Row)this._jarHash.get(jarUID);
            if (r != null) {
                if (r.value() > 1) {
                    r.decRef();
                } else {
                    this.removeAgentCode(jarUID);
                }
            }
        }
    }

    private synchronized void removeAgentCode(String mobileAgentUID) {
        Row r = (Row)this._jarHash.get(mobileAgentUID);
        if (r != null && !r.userCreatedJar()) {
            new File(r.getLocation()).delete();
        }
        this._jarHash.remove(mobileAgentUID);
    }

    private String randomString(int length) {
        StringBuffer randomName = new StringBuffer();
        int i = 0;
        while (i < length) {
            int c = this._random.nextBoolean() ? this._random.nextInt(26) + 97 : this._random.nextInt(10) + 48;
            randomName.append((char)c);
            ++i;
        }
        return randomName.toString();
    }

    private static class Row {
        private int _refs = 1;
        private String _location;
        private boolean _userCreatedJar;

        public Row(String location, boolean userCreated) {
            this._location = location;
            this._userCreatedJar = userCreated;
        }

        public String getLocation() {
            return this._location;
        }

        public void incRef() {
            ++this._refs;
        }

        public void decRef() {
            --this._refs;
        }

        public int value() {
            return this._refs;
        }

        public boolean userCreatedJar() {
            return this._userCreatedJar;
        }
    }

    private class OutputStreamHasher
    extends OutputStream {
        private OutputStream _os;
        private MessageDigest _md;

        public OutputStreamHasher(OutputStream os, MessageDigest md) {
            this._os = os;
            this._md = md;
        }

        public void write(int b) throws IOException {
            this._md.update((byte)b);
            this._os.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this._md.update(b, off, len);
            this._os.write(b, off, len);
        }
    }
}

